package ru.uss.vstore.localserver;

import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SignatureGenRequest")
public class SignatureGenRequest {

    @XmlElement(required = true)
    @Documentation("xml-представление документа для подписания")
    private String signableData;

    @XmlElement(required = true)
    @Documentation("Путь к сертификату на локальном компьютере")
    private String certificatePath;

    @XmlElement(required = true)
    @Documentation("Пароль к контейнеру с сертификатом")
    private String certificatePin;

    public String getSignableData() {
        return signableData;
    }

    public void setSignableData(String signableData) {
        this.signableData = signableData;
    }

    public String getCertificatePath() {
        return certificatePath;
    }

    public void setCertificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
    }

    public String getCertificatePin() {
        return certificatePin;
    }

    public void setCertificatePin(String certificatePin) {
        this.certificatePin = certificatePin;
    }

}
